string GetDescription()
{
	return "Renders the harmony into a track with simple chords";
}

int przew;
int low;
int high;

void SetFirstChord(RenderPart @p, int h)
{
	przew = RndInt(-1,1);
	low = p.GetHarmonicEventPitch(h, przew);
	high = p.GetHarmonicEventPitch(h, przew+p.GetHarmonicComponents(h)-1);
}

int GetDist(RenderPart @p, int harm, int pr)
{
	int l = p.GetHarmonicEventPitch(harm, pr);
	int h = p.GetHarmonicEventPitch(harm, pr+p.GetHarmonicComponents(harm)-1);
	
	int dist = 0;
	
	if (l < low) dist += low-l;
	else dist += l-low;
	
	if (h < high) dist += high-h;
	else dist += h-high;
	
	return dist;
}

void PlaceNextChord(RenderPart @p, Time t1, Time t2)
{
	int harm = 	p.GetHarmonic(t1);
	
	int pr = 0;
	int dist = GetDist(p, harm, pr);

	while (GetDist(p, harm, pr-1) < dist)
	{
		dist = 	GetDist(p, harm, pr-1);
		pr--;
	}
	
	while (GetDist(p, harm, pr+1) <= dist)
	{
		dist = 	GetDist(p, harm, pr+1);
		pr++;
	}
	
	przew = pr;
	low = p.GetHarmonicEventPitch(harm, przew);
	high = p.GetHarmonicEventPitch(harm, przew+p.GetHarmonicComponents(harm)-1);
	
	for (int f = 0; f < p.GetHarmonicComponents(harm); f++)
	{
		p.AddNote(t1, t2, p.GetHarmonicEventPitch(harm, przew+f),RndInt(105,125));	
	}
	
	
}

void Render(RenderPart @p)
{
	SetFirstChord(p,0);
		
	for (int i = 0; i < p.GetHarmonicEvents(); i++)
	{
		Time t1 = p.GetHarmonicEventStart(i);
		Time t2 = p.GetHarmonicEventEnd(i);
		PlaceNextChord(p,t1,t2);
	}
}